/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.bus;

import emulator.hardware.bus.Bus;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.MemoryBlockInterface;
import emulator.hardware.memory.UnmappedMemoryException;

public class VideoBus
implements Bus {
    Bus bus;

    public VideoBus(Bus bus) {
        this.bus = bus;
    }

    @Override
    public int read(int address) throws BusWatchException, UnmappedMemoryException {
        return this.bus.read(VideoBus.convertAddress(address));
    }

    @Override
    public void write(int address, int data) throws BusWatchException, UnmappedMemoryException {
        this.bus.write(VideoBus.convertAddress(address), data);
    }

    public static int convertAddress(int address) {
        int target = address & 0x1FFF;
        if ((address & 0x2000) == 0) {
            target += 32768;
        }
        return target;
    }

    public byte[] getMemory() {
        byte[] mem_block = null;
        try {
            MemoryBlockInterface block = (MemoryBlockInterface)((Object)this.bus);
            mem_block = block.getData();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return mem_block;
    }
}

